/***************************************************************************************
* TESTBENCH FOR RevA DC2094
* November 2013
***************************************************************************************/
`timescale 1ps/1ps

module reva_testbench();

wire CSB_33;
wire CLK;
wire CNVCLK;
wire SDO0;
wire SDO1;
wire SDO2;
wire SDO3;
wire SDO4;
wire SDO5;
wire SDO6;
wire SDO7;
wire SCK_33;
wire BUSY_33;
wire DB0;
wire DB1;
wire DB2;
wire DB3;
wire DB4;
wire DB5;
wire DB6;
wire DB7;
wire DB8;
wire DB9;
wire DB10;
wire DB11;
wire DB12;
wire DB13;
wire DB14;
wire DB15;
wire DB16;
wire DB17;
wire WRIN;
wire WRIN2;
wire B16_18L;
wire SCK_IN;
wire SCK_OUT;
wire SDI_33;
wire SDIIN;
wire SCKIN;
wire ID;
wire IDOUT;
wire A2;
wire A1;
wire A0;
wire SS2;
wire SS1;
wire SS0;
wire LVDS_CMOS_IN;
wire LVDS_CMOS_IN_JP3;
wire LVDS_CMOS_OUTPUT;
wire AUX0;
wire AUX1;
wire d_latch_out;
wire master_clk_out;
wire master_clkd_out;
wire data_latch_start;
wire [3:0]sdo_count;
wire data_latch_out;
wire CNVIN;

RevA tb (
   .CSB_33		(CSB_33),
	.CLK			(CLK),
	.CNVCLK		(CNVCLK),
	.SDO0			(SDO0),
	.SDO1			(SDO1),
	.SDO2			(SDO2),
	.SDO3			(SDO3),
	.SDO4			(SDO4),
	.SDO5			(SDO5),
	.SDO6			(SDO6),
	.SDO7			(SDO7),
	.SCK_33		(SCK_33),
	.BUSY_33		(BUSY_33),
	.DB2			(DB2),
	.DB3			(DB3),
	.DB4			(DB4),
	.DB5			(DB5),
	.DB6			(DB6),
	.DB7			(DB7),
	.DB8			(DB8),
	.DB9			(DB9),
	.DB10			(DB10),
	.DB14			(DB14),
	.DB15			(DB15),
	.DB16			(DB16),
	.DB17			(DB17),
	.DB0			(DB0),
	.DB1			(DB1),
	.DB11			(DB11),
	.DB12			(DB12),
	.DB13			(DB13),
	.WRIN			(WRIN),
	.WRIN2		(WRIN2),
	.B16_18L		(B16_18L),
	.SCK_IN		(SCK_IN),
	.SCK_OUT		(SCK_OUT),
	.SDI_33		    (SDI_33),
	.SDIIN		    (SDIIN),
	.SCKIN		    (SCKIN),
	.CNVIN		    (CNVIN),
	.ID			    (ID),
	.IDOUT		    (IDOUT),
	.A2			    (A2),
	.A1			    (A1),
	.A0			    (A0),
	.SS2			(SS2),
	.SS1			(SS1),
	.SS0			(SS0),
	.LVDS_CMOS_IN	(LVDS_CMOS_IN),
	.LVDS_CMOS_IN_JP3(LVDS_CMOS_IN_JP3),
	.LVDS_CMOS_OUTPUT(LVDS_CMOS_OUTPUT),
	.AUX0			(AUX0),
	.AUX1			(AUX1),
	.d_latch_out	(d_latch_out),
	.master_clk_out	(master_clk_out),
	.master_clkd_out(master_clkd_out),
	.data_latch_start(data_latch_start),
	.sdo_count		(sdo_count),
	.data_latch_out	(data_latch_out)
	);



 reg [395:0] data4;
 reg [395:0] data8;
 reg [395:0] data9;
 reg [395:0] data10;
 reg [395:0] data11;
 reg [395:0] data12;
 reg [395:0] dummybusy;
 reg SDO4IN;
 reg BUSY_33IN;
 reg CLKIN;
 reg SCK_OUT2;  //added 11/18/13
 reg WRIN1;
 reg WRIN21;
 reg CNVIN1;
 reg SCKIN1;
 reg SDIIN1;
 assign WRIN=WRIN1;
 assign WRIN2=WRIN21;
 assign CNVIN=CNVIN1;
 assign SCKIN=SCKIN1;
 assign SDIIN=SDIIN1;
 assign CLK=CLKIN;
 assign SDO4=SDO4IN;
 assign BUSY_33=BUSY_33IN;
 assign ID=0;
 assign B16_18L=0;
 assign SCK_OUT=SCK_OUT2;
 
/* Generating the SPI Master Clock */ 
  
initial 
begin				//		  1        10        20        30        40        50        60        70        80        90        100       110       120       130       140       150       160       170       180       190       200       210       220       230       240       250       260       270       280       290       300       310       320       330       340       350       360       370       380       390    
      CLKIN <= 1'b0;
		SCK_OUT2<=1'b0;
            data4 = 396'b000000000000000000000000000000000000000000000000000000000000110011001100110011001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111100000000000000000000000;     // dummy data
	         data8 = 396'b111111000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;     // CNVIN
			   data9 = 396'b000000010101010101010101010101010101010101010101010101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;     // SCKIN
			  data10 = 396'b000000110000000011001100001111110000110011111100111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;     // SDIIN
			  data11 = 396'b111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;     // WRIN
			  data12 = 396'b111110000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;     // WRIN2
		  dummybusy = 396'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000;	    // busy data

   	
end

 always #5000 CLKIN = ~CLKIN;
 
 
always @(negedge CLKIN) begin 
 

 SDO4IN <= data4[395];

 CNVIN1 <= data8[395];
 SCKIN1 <= data9[395];
 SDIIN1 <= data10[395];
 WRIN1 <= data11[395];
 WRIN21 <= data12[395];

 data4 <= {data4[394:0],data4[395]};

 data8 <= {data8[394:0],data8[395]};
 data9 <= {data9[394:0],data9[395]};
 data10 <= {data10[394:0],data10[395]};
 data11 <= {data11[394:0],data11[395]};
 data12 <= {data12[394:0],data12[395]};
 BUSY_33IN <= dummybusy[395];
 dummybusy <= {dummybusy[394:0],dummybusy[395]};
   
end
 always @(posedge SCK_33)begin
 SCK_OUT2 <= ~SCK_OUT2;				//added 11/19/13
  end  
endmodule